/**************************************************************************************
 
   Copyright (c) Hilscher GmbH. All Rights Reserved.
 
 **************************************************************************************
 
   Filename:
    $Id: ExtendedMemoryDialog.h 3160 2011-12-08 14:13:36Z MichaelT $
   Last Modification:
    $Author: MichaelT $
    $Date: 2011-12-08 15:13:36 +0100 (Do, 08 Dez 2011) $
    $Revision: 3160 $
   
   Targets:
     Win32/ANSI   : yes
     Win32/Unicode: yes (define _UNICODE)
     WinCE        : no
 
   Description:
    Device Extended Memory Area Dialog class
       
   Changes:
 
     Version   Date        Author   Description
     ----------------------------------------------------------------------------------
 
**************************************************************************************/

///////////////////////////////////////////////////////////////////////////////////////////
/// \file ExtendedMemoryDialog.h
///   Extended Memory Dialog class  
///////////////////////////////////////////////////////////////////////////////////////////

#pragma once

#include "BaseDialog.h"
#include "afxwin.h"

class CExtendedMemoryDialog : public CBaseDialog
{
	DECLARE_DYNAMIC(CExtendedMemoryDialog)

public:
	CExtendedMemoryDialog(CWnd* pParent = NULL);   // standard constructor
	virtual ~CExtendedMemoryDialog();

// Dialog Data
	enum { IDD = IDD_EXTENDED_MEMORY };

  virtual void    OnUpdateDevice(CCifXDeviceBase* pcDevice);
  virtual void    ThreadFunction(void)  { }


protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support
  void         UpdateUI(void);

  CCifXDeviceBase*  m_pcCurrentDevice;

  ULONG             m_ulRecvDataOffset;
  ULONG             m_ulRecvDataLen;

  BYTE*             m_pbWriteData;
  ULONG             m_ulWriteDataLen;
  ULONG             m_ulWriteDataOffset;

	DECLARE_MESSAGE_MAP()
public:
  afx_msg void OnBnClickedBtnGetMemPtr();
  afx_msg void OnBnClickedBtnMemRead();
  afx_msg void OnBnClickedBtnMemWrite();
  afx_msg void OnEnKillfocusMemoryWriteoffset();
  afx_msg void OnEnKillfocusMemoryReadoffset();
  afx_msg void OnEnKillfocusMemoryReadlength();
  virtual BOOL OnInitDialog();
};
